<?php

session_start();



if (isset($_SESSION['lead_status'])) {
    $lead_status = $_SESSION['lead_status'];
} else {
    $lead_status = 'no_lead';
}

switch ($lead_status) {
    case 'success':
        
        $title = "Grazie!";
        $message = "Il nostro rappresentante ti contatterà presto per chiarire i dettagli. Ti preghiamo di tenere il telefono a portata di mano.";
        $showCountdown = true;
        break;
        
    case 'error_no_url':
        
        $title = "Errore dell'applicazione";
        $message = "La tua richiesta non è stata accettata, ti preghiamo di riprovare più tardi.";
        $showCountdown = false;
        break;
        
    case 'no_lead':
    case 'error_curl':
    default:
        
        $title = "Grazie!";
        $message = "Il nostro rappresentante ti contatterà presto per chiarire i dettagli. Ti preghiamo di tenere il telefono a portata di mano.";
        $showCountdown = true;
        break;
}
?>
<!DOCTYPE html>
<html>
<head>
<script async src="https://www.googletagmanager.com/gtag/js?id=<?=$_GET['pixel']?>"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', '<?=$_GET['pixel']?>');
</script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Thank You</title>
    <?php if ($showCountdown): ?>
    
    <script>
        let redirectUrl = 'confirm.php';
        let countdownSeconds = 3;
    </script>
    <?php endif; ?>
    <style>
        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            text-align: center;
            background-color: #f8f9fa;
            padding: 0;
            margin: 0;
            color: #333;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            justify-content: center;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 40px 20px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        .icon {
            margin-bottom: 20px;
        }
        .icon svg {
            width: 80px;
            height: 80px;
            color: #28a745;
        }
        .title {
            font-size: 28px;
            font-weight: 600;
            margin-bottom: 20px;
            color: #2c3e50;
        }
        .message {
            font-size: 18px;
            line-height: 1.6;
            margin-bottom: 30px;
            color: #505a6c;
        }
        .countdown-text {
            font-size: 16px;
            margin-top: 30px;
            color: #6c757d;
        }
        .countdown-circle {
            position: relative;
            width: 50px;
            height: 50px;
            margin: 10px auto;
        }
        .countdown-number {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 24px;
            font-weight: bold;
            color: #007bff;
        }
        svg.circle-animation {
            transform: rotate(-90deg);
            width: 50px;
            height: 50px;
        }
        .circle-bg {
            fill: none;
            stroke: #e9ecef;
            stroke-width: 4;
        }
        .circle-progress {
            fill: none;
            stroke: #007bff;
            stroke-width: 4;
            stroke-linecap: round;
            transition: stroke-dashoffset 1s linear;
        }
        .error-icon svg {
            color: #dc3545;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="icon <?php echo ($lead_status === 'error_no_url') ? 'error-icon' : ''; ?>">
            <?php if ($lead_status === 'error_no_url'): ?>
            
            <svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" fill="currentColor" viewBox="0 0 16 16">
                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
            </svg>
            <?php else: ?>
            
            <svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" fill="currentColor" viewBox="0 0 16 16">
                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                <path d="M10.97 4.97a.235.235 0 0 0-.02.022L7.477 9.417 5.384 7.323a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-1.071-1.05z"/>
            </svg>
            <?php endif; ?>
        </div>
        <h1 class="title"><?php echo $title; ?></h1>
        <div class="message"><?php echo $message; ?></div>
        
        <?php if ($showCountdown): ?>
        <div class="countdown-text">You will be redirected in</div>
        <div class="countdown-circle">
            <svg class="circle-animation" viewbox="0 0 50 50">
                <circle class="circle-bg" cx="25" cy="25" r="20"></circle>
                <circle class="circle-progress" cx="25" cy="25" r="20" stroke-dasharray="125.6" stroke-dashoffset="0"></circle>
            </svg>
            <div class="countdown-number" id="countdown">3</div>
        </div>
        <?php endif; ?>
    </div>

    <?php if ($showCountdown): ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log("Countdown script started. Redirecting to: " + redirectUrl + " in " + countdownSeconds + " seconds");
            
            const countdownElement = document.getElementById('countdown');
            const circleProgress = document.querySelector('.circle-progress');
            const circumference = 2 * Math.PI * 20; // 2πr where r=20
            
            circleProgress.style.strokeDasharray = `${circumference}`;
            
            let secondsLeft = countdownSeconds;
            
            // Initial setup
            countdownElement.textContent = secondsLeft;
            updateCircle(secondsLeft);
            
            const countdownInterval = setInterval(function() {
                secondsLeft--;
                console.log("Countdown: " + secondsLeft);
                
                if (secondsLeft < 0) {
                    clearInterval(countdownInterval);
                    console.log("Redirecting to: " + redirectUrl);
                    window.location.href = redirectUrl;
                    return;
                }
                
                countdownElement.textContent = secondsLeft;
                updateCircle(secondsLeft);
            }, 1000);
            
            function updateCircle(seconds) {
                const offset = circumference * (1 - seconds / countdownSeconds);
                circleProgress.style.strokeDashoffset = offset;
            }
        });
    </script>
    <?php endif; ?>
</body>
</html>